/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBHeader		   = Object.create(STBModule.prototype);
STBHeader.name		   = "Header";
STBHeader.container    = jQuery(window);
STBHeader.menuPosition = null;

STBHeader.init = function() {
	var body = jQuery("body");

	if (jQuery("header .sec-nav").length) {
		body.addClass("withtopnav");
	}

	if (body.hasClass("menu-close") && !(body.hasClass("menu-side-main") || body.hasClass("menu-side-sec"))) {
		STBHeader.toggleCollapse(true);
	} else {
		STBHeader.menuChangeScheme();
	}

	STBHeader.sideMenuInit();
}

STBHeader.toggleSticky = function(val) {
	var mainNav		= jQuery(".main-nav"),
		header		= jQuery('.header'), 
		body		= jQuery("body");
	
	//prevent function from running if it already is in the needed state	
	if ( 
		((val == true) && header.hasClass("sticky")) ||
		((val == false ) && !header.hasClass("sticky"))
	) return false;

	if (STBLayoutScroller.isActive()){
		//header.addClass('sticky').removeClass("sticky2");
		//return false;
	}

	if (val) {
		header.addClass('sticky');

		//add the bgclass if exists
		STBHeader.menuChangeScheme();

	} else {
		header.removeClass('sticky');
		STBHeader.menuChangeScheme();
	}
}

STBHeader.menuChangeScheme = function() {
	//detect what scheme i should use based on body classes
	var attr	= "",
		body	= jQuery("body"),
		header	= jQuery("header");

	if (body.hasClass("menu-open")){
		if (header.hasClass("sticky")) {
			attr = "data-scheme-sticky";
		} else {
			attr = "data-scheme-top";
		}
	} else {
		attr = "data-scheme-collapsed";
	}

	var items = jQuery("[data-scheme]");

	items.each(function() {
		var item = jQuery(this);

		//remove the scheme from thie item
		if (item.attr(attr)){
			item.removeClass("ic nc").addClass(item.attr(attr));

			if (item.hasClass("navbar-collapse")) {

				//all items in the drop menu that should change the default classes
				var menuItems = item.find(
					".navbar-nav , " +
					".navbar-nav > li , " +
					".navbar-nav > li > a, " +
					".dropdown-menu:not(.with-background),  " +
					".dropdown-menu:not(.with-background) > .dropdown-menu-items > .row > div > .widget > .widget-body > ul.ic,  " +
					".dropdown-menu:not(.with-background) > .dropdown-menu-items > .row > div > .widget > .widget-body > ul.nc,  " + 
					".dropdown-menu:not(.with-background) > .dropdown-menu-items .social-logins, " + 
					".dropdown-social .dropdown-menu:not(.with-background) ul " 
				);

				if (menuItems.length > 0) {
					menuItems.removeClass("ic nc").addClass(item.attr(attr));
				}				
			}
		}
	});
}

STBHeader.sideMenuInit = function() {
	var body = jQuery("body");

	if (body.hasClass("menu-side-sec"))	{
		STBHeader.sideMenuWrap(".sec-nav");
	}

	if (body.hasClass("menu-side-main"))	{
		STBHeader.sideMenuWrap(".main-nav");
	}
}

STBHeader.sideMenuUnwrap = function (ident) {
	var el    = jQuery(ident),
		items = el.find(".navbar-collapse-scroll > *");

	items.unwrap();
}

STBHeader.sideMenuWrap = function (ident) {
	var el    = jQuery(ident),
		items = el.find(".navbar-collapse > *:not(.background)");

	items.wrapAll( "<div class='navbar-collapse-scroll' />");
}

STBHeader.toggleCollapse = function (status) {
	var body = jQuery("body");

	if (body.hasClass("menu-side-sec") || body.hasClass("menu-side-main") || body.hasClass("had-menu-side-sec") || body.hasClass("had-menu-side-main")) {

		if (status == true)	{

			if (body.hasClass("menu-side-sec"))	{
				body.removeClass("menu-side-sec").addClass("had-menu-side-sec");
				STBHeader.sideMenuUnwrap(".sec-nav");
			}

			if (body.hasClass("menu-side-main"))	{
				body.removeClass("menu-side-main").addClass("had-menu-side-main");
				STBHeader.sideMenuUnwrap(".main-nav");
			}

			if (body.hasClass("menu-side"))	{
				body.removeClass("menu-side").addClass("had-menu-side");
			}

		} else {

			if (body.hasClass("had-menu-side-sec"))	{
				body.removeClass("had-menu-side-sec").addClass("menu-side-sec");
				STBHeader.sideMenuWrap(".sec-nav");
			}

			if (body.hasClass("had-menu-side-main"))	{
				body.removeClass("had-menu-side-main").addClass("menu-side-main");
				STBHeader.sideMenuWrap(".main-nav");
			}

			if (body.hasClass("had-menu-side"))	{
				body.removeClass("had-menu-side").addClass("menu-side");
			}

		}

		if (!body.hasClass("fms")) {

			//change the menu scheme
			STBHeader.menuChangeScheme();

			//add the control class.
			body.addClass("fms");
		}

	} else {

		if (status === true) {
			body.removeClass("menu-open").addClass("menu-close");
			STBHeader.menuChangeScheme();

		} else {
			if (body.hasClass("menu-open")) {
				return true;
			}

			body.removeClass("menu-close").addClass("menu-open");
			STBHeader.menuChangeScheme();

			//remove the display: none from all drops
			jQuery(".dropdown-menu").css("display" , "");


			if (STBUtils.isBrowserFrozen())	{
				STBHeader.unlockMenu();
			}

			STBHeaderDropDown.updateWidthWait();

		}
	}
}

STBHeader.autoCollapse = function() {

	var body = jQuery("body");

	if (body.hasClass("menu-side")) {
		//return false;
	}

	if (body.hasClass("menu-working")) {
		setTimeout(function() {
			body.removeClass("menu-working");
		}, 100);
	}

	if (body.hasClass("menu-close-allways")) {
		STBHeader.toggleCollapse(true);
		STBHeaderDropDown.updateWidthWait();
		//nothing left to do here
		return true;
	}

	if (body.attr("data-menu-collapse")) {

		var width = document.documentElement.clientWidth || document.body.clientWidth,
			max = body.attr("data-menu-collapse"),
			navs = body.find("header .navbar");

			if (max < 500) {
				max = 500;
			}

			if (width < max) {
				navs.removeClass("navbar-expand");
				STBHeader.toggleCollapse(true);
			} else {

				if (!(body.hasClass("menu-side") || body.hasClass("had-menu-side"))) {
					navs.addClass("navbar-expand");
				}

				STBHeader.toggleCollapse(false);
			}

	} else {
		if (body.hasClass("menu-open")) {
			jQuery("header .navbar").addClass("navbar-expand");
		}
	}
}

STBHeader.onMouseUp = function() {
    var onMouseUp = function (e) {
        var $body = jQuery("body"), $container, $menu;

        if ($body.hasClass("moveMainNav")) {
            $container = jQuery(".main-nav .navbar-collapse");
            $menu = jQuery(".menu-button");
        } else if ($body.hasClass("moveSecNav")) {
            $container = jQuery(".sec-nav .navbar-collapse");
            $menu = jQuery(".top-menu-button");
        } else {
            return true;
        }

        if ((!$container.is(e.target) && $container.has(e.target).length === 0) && (!$menu.is(e.target) && $menu.has(e.target).length === 0)) {
            e.preventDefault();
            $menu.trigger("click");
        }
    };

    jQuery(document).bind('mouseup touchend', onMouseUp);
}

STBHeader.btnMainNav = function() {
	jQuery('.menu-button').on('click', function () {
		var body = jQuery("body");

		body.toggleClass('moveMainNav');

		if (!body.hasClass("moveMainNav")) {
			var dropNotSocial = jQuery(".main-nav li.dropdown:not(.dropdown-social)");

			dropNotSocial.removeClass("open");
			dropNotSocial.find(".dropdown-menu").hide();

			STBUtils.unfreezeBrowser();

		} else {
			STBUtils.freezeBrowser();
		}
	});
}

STBHeader.unlockMenu = function() {
	var dropNotSocial = jQuery(".main-nav li.dropdown:not(.dropdown-social) , .sec-nav li.dropdown:not(.dropdown-social)"),
		body = jQuery("body");

	//remove open classes if the menu was opened when collapsed and switches back to top menu
	body.removeClass("moveSecNav moveMainNav");
	
	dropNotSocial.removeClass("open");
	dropNotSocial.find(".dropdown-menu").show();
	
	//release browser if was frozen
	STBUtils.unfreezeBrowser();
}

STBHeader.btnSecNav = function() {
	jQuery('.top-menu-button').on('click', function () {
		var body = jQuery("body");

		body.toggleClass('moveSecNav');

		if (!body.hasClass("moveSecNav")) {
			var dropNotSocial = jQuery(".sec-nav li.dropdown:not(.dropdown-social)");

			dropNotSocial.removeClass("open");
			dropNotSocial.find(".dropdown-menu").hide();

			STBUtils.unfreezeBrowser();

		} else {
			STBUtils.freezeBrowser();
		}
	});
}

STBHeader.setContainer = function(container) {
	STBHeader.container = container;
}

STBHeader.stickyMenu = function() {
	//dont run if its a full scroller page
	if (STBLayoutScroller.isActive()){
		return false;
	}

	//dont run if page doesnt have sticky option
	if (!STBHeader.pageHasSticky()) {
		return false;
	}

	var body = jQuery("body");	

	if (body.hasClass("moveMainNav") || body.hasClass("moveSecNav"))	{
		return false;
	}

	var obj			= STBHeader.container,
		wrapper		= jQuery('.wrapper'),
		header		= jQuery('.header'),
		sticky		= body.attr("data-menu-sticky"),
		wait		= 0;

	if (!(typeof sticky !== typeof undefined && sticky !== false)) {
		body.attr("data-menu-sticky" , "false");
	}

	if (body.attr("data-menu-over-title") == "true") {
		keepSecNav = 0;
	}

	//if (STBHeader.menuPosition === null) {
		STBHeader.menuPosition = STBHeader.getMainMenuPosition();
	//}

	var menuPos = STBHeader.menuPosition;

	if (obj.scrollTop() > menuPos.pos + wait) {
		//if (STBHeader.pageHasSticky()) {
			wrapper.css('height', menuPos.height);

			STBHeader.toggleSticky(true);
			header.css("top" , menuPos.mainHeight-menuPos.height);
		//}
	} else {
		if (STBHeader.pageIsSticky()) {
			wrapper.css('height', 'auto');			

			STBHeader.toggleSticky(false);
			header.css("top", "auto");
		}
	}
}

STBHeader.getMainMenuPosition = function() {
	var menuPos			= 0,
		initialHeight	= 0,
		menuMainHeight	= 0,
		secNav			= jQuery(".header .sec-nav"),
		mainNav			= jQuery(".header .main-nav"),
		ctaMenu			= jQuery(".with-scroll .layout-cta"),
		ctaTop			= jQuery(".wrapper").prevAll(".layout-cta"),
		header			= jQuery(".header"),
		body			= jQuery("body"),
		logoHeight		= 0;

	if (ctaTop.length > 0) {
		ctaTop.each(function() {
			menuPos += jQuery(this).outerHeight();
		});
	}

	var navHeight = 0;

	if (mainNav.length > 0) {
		navHeight = mainNav.outerHeight();
	}

	if (body.hasClass("menu-open")) {

		if (STBModuleTopintro.pageHasTopIntro()) {

			menuPos += STBHeader.container.outerHeight();
			
			if (body.attr('data-topintro-menu') === 'true')	{

				menuPos -= navHeight;

			} else {

				if (secNav.length > 0 ) {
					menuPos += secNav.outerHeight();
				}

				if (ctaMenu.length > 0 ) {
					menuPos += ctaMenu.outerHeight();
				}

			}

		} else {

			if (secNav.length > 0 ) {
				menuPos += secNav.outerHeight();
			}

			if (ctaMenu.length > 0 ) {
				menuPos += ctaMenu.outerHeight();
			}

		}

		if (body.hasClass("main-navbar-top") && (body.attr("data-menu-sticky-logo") === "false") && (jQuery(".navbar-brand").length > 0)) {
			logoHeight = jQuery(".navbar-brand").outerHeight();
			menuPos += logoHeight;
		}

		if (secNav.length > 0 ) {
			initialHeight += secNav.outerHeight();
		}

		if (ctaMenu.length > 0 ) {
			initialHeight += ctaMenu.outerHeight();
		}

	} else {

		if (STBModuleTopintro.pageHasTopIntro()) {

			menuPos += STBHeader.container.outerHeight();

			if (body.attr('data-topintro-menu') === 'true')	{		
				menuPos -= navHeight;
			}

		}
		
	}

	var data = {
		pos			: menuPos,
		height		: navHeight + initialHeight, 
		mainHeight	: navHeight - logoHeight
	}

	//if full page scroller end here
	if (body.attr("data-scroll-page") === "true") {
		return data;
	}

	//fix the first element form menu
	if (body.attr("data-menu-over-title") === "true") {
		var first		= jQuery("main > *").first(),
			topPadding	= 0;

		if (!first.attr("data-top")) {
			first.attr("data-top" , first.css("padding-top"));
		}

		topPadding = first.attr("data-top");

		if (first.hasClass("slider-holder")) {
			first.css({
				"margin-top"	: -(data.height)
			});
		} else {
			var topPadding = parseFloat(data.height) +  parseFloat(topPadding);

			first.css({
				"margin-top"	: -(data.height),
				"padding-top"	: topPadding
			});

			if (first.hasClass("full-page")) { 
				first.find("> .container-data > .row").attr("style" , "min-height: calc(100vh - " + topPadding + "px);");
			}
		}
	}

	return data;
}

STBHeader.pageHasSticky =  function() {
	return (jQuery("body").attr("data-menu-sticky") == "true");
}

STBHeader.pageIsSticky =  function() {
	return (jQuery("header").hasClass("sticky"));
}

STBHeader.pageHasOverContent = function() {
	return (jQuery("body").attr("data-menu-over-title") == "true");
}

STBHeader.menuOverContent = function(status) {
	jQuery("body").attr("data-menu-over-title" , status ? "true" : "false");
}

STBHeader.runOnLoad = function() {
	STBHeader.menuPosition = STBHeader.getMainMenuPosition();
}

STBHeader.runOnScroll = function() {
	STBHeader.stickyMenu();
}

STBHeader.runOnReady = function() {
	STBHeader.init();
	STBHeader.onMouseUp();
	STBHeader.btnMainNav();
	STBHeader.btnSecNav();
	STBHeader.autoCollapse();
	STBHeader.menuPosition = STBHeader.getMainMenuPosition();
	STBHeader.stickyMenu();

}

STBHeader.runOnResize = function() {
	STBHeader.autoCollapse();
	STBHeader.stickyMenu();
	STBHeader.menuPosition = STBHeader.getMainMenuPosition();
}

site.registerModule(STBHeader);